/*************************************************************************
  Overlay     Flip between two loaded files, showing differences

  Author:     Steve Watkins (SemWare)

  Date:       June 1991     Original version
              April 1992    Updated for 1.0 release
              May 1995      Updated for 2.5 release

  Overview:

  Flips between two files on the screen QUICKLY so file differences
  are apparent.  This macro is intended to show differences in text
  which is somewhat similar. I use the macro to display differences
  between two similar files of source.  This indicates when lines have
  been added or deleted. I then update one or the other files by
  inserting the appropriate # of lines as necessary to only "flicker"
  differences on similar lines

  If bookmarks 'A' and 'B' are placed (configurable below) the files
  containing these bookmarks are flipped.

  If bookmarks are not specified, Current and Next Files are flipped

  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/


// configurable data

string bookmark1[1] = 'a'
string bookmark2[1] = 'b'

// end configurable data

integer first_file = TRUE
integer id1, id2

proc ToggleFile()
    GotoBufferId( iif(first_file,id1,id2) )
    UpdateDisplay(0x1f)
    first_file = not first_file
end ToggleFile

integer proc FlipEm()
    integer key, use_bookmarks = FALSE, count

    HideMouse()
    PushPosition()
    GotoMark(bookmark2)         // make sure we're not sitting on bookmark1
    if GotoMark(bookmark1)
        id1 = GetBufferId()
        if GotoMark(bookmark2)  // make sure there's a bookmark2 <> bookmark1
            id2 = GetBufferId()
            if id2 <> id1
                use_bookmarks = TRUE
            endif
        endif
    endif
    PopPosition()

    if not use_bookmarks        // use Current and Next Files
        id1 = GetBufferId()
        if NextFile()
            id2 = GetBufferId()
            PrevFile()
        else
            return (FALSE)
        endif
    endif

    loop
        if keypressed()
            key = getkey()

            count = 2
            repeat
                case key
                    when <Ctrl Y>       DelLine()
                    when <PgDn>         PageDown()
                    when <PgUp>         PageUp()
                    when <CursorDown>   Down()
                    when <CursorUp>     Up()
                    when <CursorLeft>   Left()
                    when <CursorRight>  Right()
                    when <Ctrl z>       ScrollDown()
                    when <Ctrl w>       ScrollUp()
                    when <Home>         BegLine()
                    when <End>          EndLine()
                    when <Ctrl PgUp>    BegFile()
                    when <Ctrl PgDn>    EndFile()
                    when <Ctrl CursorUp>RollUp()
                    when <Ctrl CursorDown>RollDown()
                    when <f5>           ScrollToTop()
                    when <shift f5>     ScrollToCenter()
                    otherwise           if not first_file
                                            ToggleFile()
                                            ShowMouse()
                                            Message("Halting...")
                                            return (TRUE)
                                        endif
                endcase
                ToggleFile()
                count = count - 1
            until count == 0
        else
            ToggleFile()
        endif
    endloop
    ShowMouse()
    return (FALSE)
end FlipEm


proc main()
    FlipEm()
end


