string proc input_str(string prompt)
    string response[1] = ""

    loop
        Write(prompt)
        Read(response)
        WriteLine("")
        if Trim(response) <> ""
            break
        endif
        WriteLine("You must enter a response")
    endloop
    return (response)
end

integer proc input_int(string prompt, var integer pressed_esc)
    string response[4] = ""

    pressed_esc = false
    loop
        Write(prompt + " - <Esc> to quit")
        if not ReadNumeric(response)
            pressed_esc = true
            return (0)
        endif
        WriteLine("")
        if Trim(response) <> ""
            break
        endif
        WriteLine("You must enter a response")
    endloop
    return (Val(response))
end

proc detachment()
    integer i

    writeline("Ready for detachment")
    writeline("-- COUNTDOWN --")
    for i = 10 downto 0
      writeline(i)
      delay(5)
    endfor
    writeline("You have left the spacecraft.")
    writeline("Try to land with velocity less than 5 m/sec.")
    writeline("")
end

proc print_values(integer v, integer f, integer h)
    writeline("Meter readings")
    writeline("--------------")
    writeline("Fuel (gal): ", f)
    if h == 0
       writeline("Landing velocity (m/sec): ")
    else
       writeline("Velocity (m/sec): ")
    endif
    writeline(v)
    writeline("Height (m): ", h)
    writeline("")
end

integer proc user_input(integer f, var integer pressed_esc)
    integer u

    u = 0
    if f > 0
        repeat
            u = input_int("How much fuel will you use?", pressed_esc)
            if pressed_esc
                break
            elseif u < 0
               writeline("No cheating please!  Fuel must be >= 0.")
            elseif u > f
                writeline("Sorry, you have not got that much fuel!")
            endif
        until u > 0 and u <= f
    endif
    return (u)
end

proc caculate(var integer f, integer g, var integer h, integer u, var integer v)
    h = h - v
    v = ((v + g) * 10 - u * 2) / 10
    f = f - u
end

proc report(integer v)
    if v <= 5
       writeline("Congratulations!  This was a very good landing.")
    else
       writeline("You have crashed.")
    endif
    writeline("")
end

proc initialise(var integer v, var integer f, var integer h, var integer g)
    v = 70
    f = 500
    h = 1000
    g = 2
end

proc main()
    integer u, v, f, h, g, pressed_esc = false

    popwinopen(1, 1, Min(63, Query(ScreenCols)), Query(ScreenRows), 1, "Lunar Lander", 7)
    set(Attr, 7)
    clrscr()
    repeat
        writeline("You are aboard the Lunar Lander about to leave the spacecraft.")
        detachment()
        initialise(v, f, h, g)

        while h > 0
            print_values(v, f, h)
            u = user_input(f, pressed_esc)
            if pressed_esc
                break
            endif
            caculate(f, g, h, u, v)
        endwhile
        if pressed_esc
            break
        endif

        h = 0
        print_values(v, f, h)
        report(v)
    until input_str("Do you want to play again? (y/n)") <> 'y'

    writeline("")
    writeline("Have a nice day - press a key.")
    getkey()
    popwinclose()
end

