/*************************************************************************
  LdFList     Loads all files listed in the current file

  Author:     SemWare

  Date:       March, 1995

              November 10, 1995 bar     Fix zero-length file name bug.
                                        More delimiter/break characters.

              Nov 1996 SEM              Fix logic in parsing loop.

              Feb 2003 SEM              load files listed by grep, in
                                        format: File:filename

              Aug 2015 SEM              Respect marked block

              Mar 21 2019 SEM           Don't quit the "file list" file.
              Mar 02 2020 SEM           Start at column 1 for line blocks, else
                                        we might not get the entire filename.

              Oct 18 2023 Carlo         Not or no longer existing files stopped
                                        ldflist in a seemingly random place in
                                        the list.
                                        Now continues and also reports the
                                        number of not loaded files.
                                        Fixed listed files being added in the
                                        middle of the ring, if one of them was
                                        already loaded previously.

  Overview:

  This macro will load all files listed in the current file.

  Keys:       (none)

  Usage notes:

  The list of files to be loaded is assumed to be in the following
  format:

  filename1
  filename2
  filename3
  filename4

  The list of files is abandoned after the command is completed.


  Copyright 1992-1995 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/


integer proc findGreppedFile(string options)
    return (lFind("File: \c", "^x" + options))
end

proc mAddFileToRing(var integer cur_id,
                    var integer ok_count,
                    var integer err_count)
    integer tst_id = 0

    PushBlock()
    PushLocation()
    MarkToEOL()
    GotoBufferId(cur_id)
    tst_id = AddFileToRing(Trim(GetMarkedText()))
    if tst_id
      ok_count = ok_count + 1
      cur_id   = Max(cur_id, tst_id) // Maintan order if already loaded file.
    else
      err_count = err_count + 1
    endif
    PopLocation()
    PopBlock()
end

proc Main()
    integer start_id, cur_id, ok_count, err_count //, changed
    string options[10]

    start_id = GetBufferId()
    cur_id = start_id
    ok_count = 0
    err_count = 0
    PushBlock()
    PushPosition()

    if not isBlockInCurrFile()
        MarkAll()
    endif
    options = "l"
    GotoBlockBegin()
    if isBlockMarked() == _LINE_    // bug-fix: start at line 1 for line blocks,
        GotoColumn(1)               // so we get the entire filename
    endif

    if findGreppedFile(options)
        repeat
            mAddFileToRing(cur_id, ok_count, err_count)
            EndLine() // so find will start on next line
        until not findGreppedFile(options)
    else
        repeat
            mAddFileToRing(cur_id, ok_count, err_count)
        until not Down() or not isCursorInBlock()
    endif

    PopPosition()
    PopBlock()
//    changed = FileChanged()
//    NextFile()
//    if not changed
//        AbandonFile(start_id)
//    endif
    Message(ok_count, " File(s) loaded."; err_count; 'File(s) not loaded.')
end

