string proc Read_Paste()
    string s[255]

    PushLocation()
    GotoBufferId(Query(ClipBoardid))
    BegFile()
    s = GetText(1, CurrLineLen())
    PopLocation()
    return (s)
end

string proc Read_PasteFromWinClip()
    integer win_clip_id
    string s[255]

    PushLocation()
    win_clip_id = GetWorkBuffer()
    PushBlock()
    PasteFromWinClip()
    PopBlock()
    BegFile()
    s = GetText(1, CurrLineLen())
    FreeWorkBuffer(win_clip_id)
    PopLocation()
    return (s)
end

/****************************************************************************
  An Incremental search.  I rarely use regular search, since implementing
  this...

  02 May 2009 - SEM - removed a redundant variable - thanks to John Kopp.
  13 May 2010 - SEM -
            [ctrl L] on an empty search string retrieves from history
            [enter] on a blank string calls find
            Thanks to Ross Barnes for the suggestions.
 ***************************************************************************/
string isrch_options[8] = "i"

string help_entry[] = "IncrementalSearch feature"

proc ToggleOption(string c)
    isrch_options = iif(pos(c, isrch_options),
            DelStr(isrch_options, pos(c, isrch_options), 1),
            isrch_options + c)
end

proc main()
    integer start_xoffset, key, done, skip
    string s[255], options[10]

    s = ""
    options = ""
    start_xoffset = CurrXOffset()

    done = false
    skip = false
    PushPosition()
    repeat
        message("L ", CurrLine():Length(Str(NumLines())), " I-Search [", isrch_options, options, "]:", s)

        key = getkey()
        case key
            when <F1>
                Help(help_entry)
                skip = true
            when <BackSpace>                // go back to start
                PopPosition()
                s = s[1:length(s) - 1]
                if Length(s) == 0
                    if Pos('g', options)
                        BegFile()
                    endif
                    UpdateDisplay()
                endif
                PushPosition()
            when <Ctrl L>, <Ctrl N>         // just search again
                if s == ""
                    s = GetHistoryStr(_FIND_HISTORY_, 1)
                endif
                options = '+'
            when <Ctrl R>, <Ctrl P>, <CtrlShift L>  // go to previous occurrence
                options = 'b'
            when <Ctrl G>, <Ctrl B>         // beginning of file
                options = 'g'
            when <Ctrl A>
                ToggleOption('a')
            when <Ctrl I>
                ToggleOption('i')
            when <Ctrl W>
                ToggleOption('w')
            when <Ctrl 6>
                ToggleOption('^')
            when <Ctrl 4>
                ToggleOption('$')
            when <alt c>
                pushkeystr(GetMarkedText())
            when <ctrl v>
                pushkeystr(Read_PasteFromWinClip())
            when <grey*>
                pushkeystr(Read_Paste())
            when <F5>
                ScrollToTop()
                done = true
            when <Shift F5>
                ScrollToCenter()
                done = true
            when <Enter>, <Escape>, <Alt x>
                if s == ""
                    if key == <Enter>
                        Find()
                    endif
                else
                    AddHistoryStr(s, _FIND_HISTORY_)
                endif
                done = true
            otherwise
                if isTypeableKey(key)
                    s = s + Chr(LoByte(key))    // add only the char portion
                else
                    skip = true
                endif
        endcase
        if not done or not skip
            GotoXOffset(start_xoffset)
            if Length(s)
                if NOT find(s, isrch_options + options) and options == ""
                    s = s[1: length(s) - 1]
                else
                    options = ""
                endif
            endif
        endif
        skip = false
    until done
    KillPosition()
    UpdateDisplay()
end

