dll "<kernel32.dll>"
    proc Sleep(integer milliseconds) : "Sleep"
end

integer proc BIOSShiftState()
    return (GetKeyFlags())
end

constant    GunWidth        = 5,
            GunHeight       = 2,
            BulletChar      = 219,
            InvaderChar     = 157,
            InvadersPerLine = 15,

            sSHIFT          = (_RIGHT_SHIFT_KEY_|_LEFT_SHIFT_KEY_)

string save_font_name[80], terminal[] = "Terminal"
integer user_settings_changed, save_point_size, save_font_flags, save_rows, save_cols

integer GunPos = 37,
        gameID,
//        DelayFactor,
        Firing,
        FireY,
        InvadersLeft,
        Invaded,
        Level,
        Score,
        BombsLeft

string  GunStr1[]   = ' ',
        GunStr2[]   = '',
        GroundStr[] = ''

proc mDelay(integer hs)
    Sleep(hs)
end

proc PopMessage(string msg, integer dlay)
    integer x, y, a = Set(Attr, Color(Bright White on Black))

    x = (Query(ScreenCols) / 2) - (Length(msg) / 2)
    y = Query(ScreenRows) / 2 - 5

    if PopWinOpen(x, y, x+Length(msg), y, 0, '', 0)
        Set(Attr, Color(Bright White on Black))
        ClrScr()
        PutStr(msg)
        mDelay(dlay)
        PopWinClose()
    endif
    Set(Attr, a)
end

proc DrawGun(integer erase)
    integer a = Query(Attr)

    if erase
        Set(Attr, 0)
    endif
    VGotoXYAbs(GunPos,Query(ScreenRows)-1)
    PutStr(GunStr1)
    VGotoXYAbs(GunPos,Query(ScreenRows))
    if erase
        Set(Attr, Color(Bright Green on Black))
        PutStr(GroundStr)
    else
        PutStr(GunStr2)
    endif
    Set(Attr, a)
end

integer proc GetHSecs()
    integer hh, mm, ss, hs

    GetTime(hh,mm,ss,hs)
    return (hh * 360000 + mm * 6000 + ss * 100 + hs)
end

proc CleanUp()
    if user_settings_changed
        SetFont(save_font_name, save_point_size, save_font_flags)
        SetVideoRowsCols(save_rows, save_cols)
    endif
end

proc Initialize()
    integer point_size, rows, cols

    user_settings_changed = false
    save_rows = Query(ScreenRows)
    save_cols = Query(ScreenCols)
    GetFont(save_font_name, save_point_size, save_font_flags)
    point_size = save_point_size

    if not EquiStr(terminal, save_font_name) or save_rows < 25 or save_cols < 80
        user_settings_changed = true
        repeat
            SetFont(terminal, point_size, _FONT_OEM_)
            if Query(ScreenRows) > 24 and Query(ScreenCols) > 79
                break
            endif
            GetMaxRowsCols(rows, cols)
            if rows > 24 and cols > 79
                SetVideoRowsCols(25, 80)
                break
            endif
            point_size = point_size - 1
        until point_size < 5
    endif

    gameID = CreateTempBuffer()
    Window(1,1,Query(ScreenCols),Query(ScreenRows))
    Set(Attr, Color(Bright Cyan on Black))
    ClrScr()
    VGotoXYAbs(1,2)
    PutCharH('',Query(ScreenCols))
    Window(1,3,Query(ScreenCols),Query(ScreenRows)-GunHeight)
    VGotoXYAbs(1, Query(ScreenRows))
    Set(Attr, Color(Bright Green on Black))
    PutCharH('', Query(ScreenCols))
    Set(Attr, Color(Bright Yellow on Black))
    DrawGun(0)

    Invaded = FALSE
    Firing = FALSE
    Level = 0
    Score = 0
    BombsLeft = 2
end

constant    mLEFT   = -1,
            mRIGHT  =  1

proc MoveGun(integer dir)
    integer newpos = GunPos + dir

    if newpos > 0 and newpos <= Query(ScreenCols) - GunWidth + 1
        DrawGun(1)
        GunPos = newpos
        Set(Attr, Color(Bright Yellow on Black))
        DrawGun(0)
    endif
    while KeyPressed()
        GetKey()
    endwhile
end

integer proc InvaderAt(integer x, integer y)
    GotoLine(y)
    GotoColumn(x)
    return (CurrChar() == InvaderChar)
end

proc DestroyInvader(integer x, integer y)
    integer i = 15, a = Query(Attr)
    GotoLine(y)
    GotoColumn(x)
    InsertText(' ',_OVERWRITE_)
    repeat
        VGotoXYAbs(x, y)
        Set(Attr, i)
        PutChar('')
        mDelay(5)
        i = i - 1
    until i < 0
    InvadersLeft = InvadersLeft - 1
    Score = Score + (Level * 10)
    Set(Attr, a)
end

proc CheckFire()
    integer a = Set(Attr, Color(Bright Red on Black)),
            x = GunPos+(GunWidth/2)

    if Firing
        FireY = FireY - 1
        if FireY > 2
            if InvaderAt(x, FireY)
                DestroyInvader(x, FireY)
                Firing = FALSE
                FireY = Query(ScreenRows) - GunHeight
            else
                VGotoXYAbs(x, FireY)
                PutChar(Chr(BulletChar))
                mDelay(10)
                VGotoXYAbs(x, FireY)
                PutChar(' ')
            endif
        else
            Firing = FALSE
            FireY = Query(ScreenRows) - GunHeight + 1
        endif
    endif
    Set(Attr, a)
end

proc AttrScr(integer a)
    integer y = 3

    while y <= Query(ScreenRows) - GunHeight
        VGotoXYAbs(1, y)
        PutAttr(a, Query(ScreenCols))
        y = y + 1
    endwhile
end

proc Bomb()
    integer i = 10

    if BombsLeft
        BombsLeft = BombsLeft - 1
        while i
            AttrScr(Color(Black on White))
            mDelay(70)
            AttrScr(Color(White on Black))
            mDelay(10)
            i = i - 1
        endwhile
        ClrScr()
        PopMessage(Format(BombsLeft,' Bomb(s) left!'), 2000)
        Score = Score + (10 * InvadersLeft)
        InvadersLeft = 0
        Firing = FALSE
        FireY = Query(ScreenRows) - GunHeight + 1
    endif
end

proc PutInvader(integer x, integer y)
    GotoLine(y)
    GotoColumn(x)
    InsertText(Chr(InvaderChar),_OVERWRITE_)
    VGotoXYAbs(x, y)
    Set(Attr, (x mod 15) + 1)
    PutChar(Chr(InvaderChar))
end

proc UpdateInvaders()
    integer x, y, i

    if InvadersLeft <= 0
        EmptyBuffer()
        i = Query(ScreenRows)
        while i
            AddLine()
            i = i - 1
        endwhile
        x = 25
        y = 3
        while y < 7
            i = y mod 2
            while i < (InvadersPerLine * 2)
                PutInvader(x+i, y)
                i = i + 2
            endwhile
            y = y + 1
        endwhile
        Level = Level + 1
        if (Level mod 5) == 0
            BombsLeft = BombsLeft + 1
        endif
        InvadersLeft = InvadersPerLine * 4
    else
        GotoLine(Query(ScreenRows)-GunHeight)
        MarkLine()
        MarkLine()
        if lFind(Chr(InvaderChar),'gl')
            Invaded = TRUE
        else
            DelLine()
            BegFile()
            InsertLine()
            if lFind(Chr(InvaderChar),'g')
                ClrScr()
                repeat
                    VGotoXYAbs(CurrCol(), CurrLine())
                    Set(Attr, (CurrCol() mod 15) + 1)
                    PutChar(Chr(InvaderChar))
                until not lRepeatFind()
            else
                Warn('Fatal Error 101')
            endif
        endif
        UnMarkBlock()
    endif
end

proc SignOnScreen()
    integer x1 = Query(ScreenCols)/2 - 15,
            y1 = Query(ScreenRows)/2 - 10

    if PopWinOpen(x1, y1, x1+32, y1+11, 2, '', Query(MenuBorderAttr))
        Set(Attr, Query(MenuTextAttr))
        ClrScr()
        WriteLine("")
        WriteLine("         INVADERS     ")
        WriteLine("")
        WriteLine("")
        WriteLine("  <- and -> keys to move Gun ")
        WriteLine("")
        WriteLine("  Either 'Shift' key to fire ")
        WriteLine("")
        Write    ("  <SpaceBar> to use a Bomb ")
        GetKey()
        PopWinClose()
    endif
end

proc main()
    integer cursor = Set(Cursor, Off), eek = Set(EquateEnhancedKbd, On),
            msglvl = Set(MsgLevel, _NONE_),
            lasttime = 0, attr
    string  name[25] = ''

    HideMouse()

    Initialize()
    SignOnScreen()
    loop
        if (InvadersLeft == 0) or ((GetHSecs() - lasttime) > (50 - (Level * 5)))
            UpdateInvaders()
            lasttime = GetHSecs()
        endif
        if Invaded
            Set(Attr, Color(Blink Bright White on Black))
            VGotoXY(28, 8)
            PutStr('YOU HAVE BEEN INVADED!!!')
            Set(Attr, Color(Bright Red on Black))
            VGotoXY(29, 10)
            PutStr('Press <Escape> to exit')
            repeat until GetKey() == <Escape>
            break
        endif
        VGotoXYAbs(1,1)
        Set(Attr, Color(Bright White on Black))
        PutStr(Format(' Bombs = ',BombsLeft:3,'Score = ':26,Score:9,'Level = ':28,Level:2))
        if BIOSShiftState() & sSHIFT
            Firing = TRUE
        endif
        CheckFire()
        if KeyPressed()
            case GetKey()
                when <CursorLeft>,  <Shift CursorLeft>
                    MoveGun(mLEFT)
                when <CursorRight>, <Shift CursorRight>
                    MoveGun(mRIGHT)
                when <Spacebar>
                    Bomb()
                when <Escape>
                    Set(X1, Query(ScreenCols)/2-10)
                    Set(Y1, Query(ScreenRows)/2-5)
                    attr = Query(Attr)
                    if YesNo('Exit INVADERS?') == 1
                        break
                    endif
                    Set(Attr, attr)
            endcase
        endif
    endloop
    if Score and EditFile('scores')
        Set(Cursor, On)
        if NumLines()
            GotoLine(3)
            loop
                if Score >= Val(GetText(2,10))
                    Ask('Enter your name for the High Score Table',name)
                    InsertLine(Format(Score:10,'  ',name))
                    if NumLines() > 12
                        EndFile()
                        DelLine()
                    endif
                    break
                endif
                if not Down()
                    if NumLines() < 12
                        goto add_it
                    else
                        goto dont_add_it
                    endif
                endif
            endloop
        else
            AddLine('     Score  Name')
            AddLine('')
            add_it:
            Ask('Enter your name for the High Score Table',name)
            AddLine(Format(Score:10,'  ',name))
            dont_add_it:
        endif
        lList('High Scores',40,NumLines(),0)
        SaveAndQuitFile()
    endif
    InvadersLeft = -1
    AbandonFile(gameID)
    CleanUp()
    Set(Cursor, cursor)
    Set(EquateEnhancedKbd, eek)
    Set(MsgLevel, msglvl)
    ShowMouse()
    Window(1,1,Query(ScreenCols),Query(ScreenRows))
    UpdateDisplay(_ALL_WINDOWS_REFRESH_|_HELPLINE_REFRESH_)
end

