/*************************************************************************
  InsMatch    Inserts the matching character for a specific groups of chars

  Author:     SemWare

  Date:       Mar 20, 1992 - Initial version (Richard Blackburn)
              Apr 23, 1993 - Re-written to use KeyDefs
              Jul 21, 1994 - Modified to be more like TSE Jr
              Apr  9, 1999 - Fix up the builtin cmode
              October 2003 - Greg Macdonald: Add C# support

  Overview:

  This macro causes the editor to insert the matching character for a
  specific group of bracketing character pairs, including the
  following:  [], (), {}, <>, '', "".  Execute this macro to toggle
  the "insert matching" mode ON or OFF.  When ON, the matching
  character of a pair is automatically inserted when you type the
  first character.  For example, if you enter the character {, this
  macro inserts the matching character, }.

  Keys:     Char  Inserts
              [     []
              (     ()
              '     ''
              "     ""
              {     {}
              <     <>

  Usage notes:

  This macro does not have any key assignments.  To use, simply select
  it from the Potpourri menu.

  To disable the macro, simply purge it (via the Macro->Purge menu).

  Copyright 1992-2003 SemWare Corporation.  All Rights Reserved Worldwide.

  Use, modification, and distribution of this SAL macro is encouraged by
  SemWare provided that this statement, including the above copyright
  notice, is not removed; and provided that no fee or other remuneration
  is received for distribution.  You may add your own copyright notice
  to cover new matter you add to the macro, but SemWare Corporation will
  neither support nor assume legal responsibility for any material added
  or any changes made to the macro.

*************************************************************************/

integer
    use_cmode   = TRUE

integer proc cmode()
    return (use_cmode and Lower(SplitPath(CurrFilename(), _EXT_)) in ".cs", ".c", ".cc", ".cpp", ".h", ".hpp")
end

proc InsMatch(string s)
    integer p

    SelfInsert()            // Put character in file based on InsertMode
    if s <> '}' or not cmode()
        InsertText(s, _INSERT_) // Insert match character
        Left()
    else
        p = PosFirstNonWhite()
        AddLine()
        AddLine()
        GotoPos(p)
        InsertText(s, _INSERT_)
        Up()
        TabRight()
    endif
end

/***********************************************************************
  This keydef when active will insert both the character represented
  by the key pressed and its matching key.  It moves back to the left
  to place you within the two characters.
***********************************************************************/

keydef ent_match
    <[>         InsMatch(']')
    <'>         InsMatch("'")
    <">         InsMatch('"')
    <(>         InsMatch(')')
    <{>         InsMatch('}')
    <<>         InsMatch('>')
end

proc WhenLoaded()
    Enable(ent_match)
end

