integer temp_id

/*************************************************************************
  Copy a marked block to the Windows clipboard.
  Before being copied, the marked block is wrapped at the maximum line
  length.

  * Lines starting with 4 or more spaces or a tab are not wrapped.
  * Lines of only '*' or '-', or '_' are not wrapped.

 *************************************************************************/

integer proc skip_indented_text()
    integer n

    loop
        n = PosFirstNonWhite()

        if (n > 0 and n < 4) and CurrChar(1) <> 0x09
            return (true)
        endif

        if not Down()
            return (false)
        endif

    endloop
    return (false)
end

proc main()
    integer right_margin, marked_it

    marked_it = False
    if isBlockMarked()
        if not isBlockInCurrFile()
            Warn("Block not in current file")
            return ()
        endif
    elseif Query(UseCurrLineIfNoBlock)
        MarkLine()
        marked_it = True
    else
        Warn("No block")
        return ()
    endif

    right_margin = Set(RightMargin, MAXLINELEN)
    PushBlock()
    PushPosition()
    if temp_id == 0 or not GotoBufferId(temp_id)
        temp_id = CreateTempBuffer()
    endif
    EmptyBuffer()
    CopyBlock()
    BegFile()
    repeat
    until not skip_indented_text() or not WrapPara()
    BegFile()
    MarkChar()
    EndFile()
    MarkChar()
    CopyToWinClip()

    Set(RightMargin, right_margin)
    PopPosition()
    PopBlock()
    if marked_it or Query(UnMarkAfterPaste) <> Off
        UnMarkBlock()
    endif
end

