/*************************************************************************

Sample source: bad.java

class HelloWorld {
    integer i

    public static void main(String[] args) {
        System.out.println("Hello World!");
    }
    if this works, I'll be surprised
}

Sample error messages:

Found 1 lexical error in "C:/d/user/jikes_cmplr/bad.java":

     7.     if this works, I'll be surprised
                            ^--^
*** Lexical Error: Character constant not properly terminated.

Found 5 syntax errors in "C:/d/user/jikes_cmplr/bad.java":

     2.     integer i
            ^-------^
*** Syntax Error: ";" inserted to complete ClassBodyDeclarations

            <
     6.     }
     7.     if this works, I'll be surprised
        ---------->
*** Syntax Error: Type expected instead

     7.     if this works, I'll be surprised
                            ^--^
*** Syntax Error: ; expected instead of this token

     7.     if this works, I'll be surprised
                                ^----------^
*** Syntax Error: ";" inserted to complete BlockStatement

                         <
     1. class HelloWorld {
   . . .
     8. }
        >
*** Syntax Error: "}" inserted to complete ClassBody

 *************************************************************************/

/*************************************************************************
   unprocessed error buffer format is:

   line-number:8 col-number:5 fn error message

   This format is necessary so that we can sort the messages in line
   number order, before placing bookmarks.

   The compile macro expects this file to be in this format:

   fn
   line-number col-number
   error message

 *************************************************************************/
integer debug
string press_a_key[] = ". Press a key"

proc Msg(string s)
    integer n

    if debug
        n = Length(s)
        if n - SizeOf(press_a_key) > Query(ScreenCols)
            n = Query(ScreenCols) - SizeOf(press_a_key)
        endif
        Message(s:n,press_a_key)
        GetKey()
    else
        Message(s)
    endif
end

proc DbgMsg(string s, integer redraw)
    if debug
        if redraw
            UpdateDisplay()
        endif
        Msg(s)
    endif
end

string proc remove_tok()
    string s[MAXSTRINGLEN] = ""

    while CurrChar() >= 0 and isWhite()
        DelChar()
    endwhile

    while CurrChar() >= 0 and not isWhite()
        s = s + GetText(1, 1)
        DelChar()
    endwhile

    while CurrChar() >= 0 and isWhite()
        DelChar()
    endwhile

    return (s)
end

proc format_errors(integer err_id)
    string line[10], col[10], fn[_MAX_PATH_]

    GotoBufferId(err_id)
    DbgMsg("In format_errors", True)
    if NumLines() > 0
        BegFile()

        // input: line col "fn" error message
        // output:
        // fn
        // line col
        // error message
        repeat
            BegLine()
            line = remove_tok()
            col  = remove_tok()
            fn   = remove_tok()
            InsertLine(fn)
            AddLine(Format(line; col))
            Down()
        until not Down()
    endif
end

integer proc find_errors(string cur_fn, integer err_id, integer work_id)
    string s[MAXSTRINGLEN], fn[_MAX_PATH_]
    integer line, col, col0, start_ln, end_ln, count

    DbgMsg("In find_errors", False)
    count = 0
    BegFile()
    while lFind("Found [0-9]# .* errors? in .*:", "x")
        start_ln = CurrLine()
        end_ln = iif(lRepeatFind(), CurrLine(), NumLines())
        GotoLine(start_ln)
        fn = iif(lFind('"{.*}":$', 'x'), GetFoundText(1), cur_fn)

        // find the (first/next) error marker
        while lFind("*** ", "^") and CurrLine() < end_ln
            s = GetText(5, MAXSTRINGLEN)
            Up(2)
            if lFind("^ #{[0-9]#}\.", "cx")
                line = Val(GetFoundtext(1))
                lFind('.', '')
                col0 = CurrCol() + 1
                col = 1
                if Down() and lFind("{\^}|{\>}", "cgx")
                    col = CurrCol() - col0
                endif

                GotoBufferId(err_id)
                AddLine(s)
                BegLine()
                InsertText(QuotePath(fn) + ' ', _INSERT_)
                BegLine()
                InsertText(Format(line:8; col:5, ' '))
                count = count + 1
                GotoBufferId(work_id)
            endif
            Down(2)
            if not Down()
                break
            endif
        endwhile

        GotoLine(end_ln)
        Up()
    endwhile
    DbgMsg(Format(count; "errors found in find_errors"), False)
    return (count)
end

proc sort_error_buffer(integer err_id)
    // Sort error buffer
    GotoBufferId(err_id)
    DbgMsg("In sort_error_buffer", True)
    if NumLines() > 0
        PushBlock()
        MarkLine(1, NumLines())
        Sort()
        PopBlock()
        BegFile()
    endif
end

/*************************************************************************
  Called as: macro cur_fn err_id
  The current buffer is the compiler output
 *************************************************************************/
public proc jikes()
    string s[MAXSTRINGLEN], cur_fn[_MAX_PATH_]
    integer err_id, work_id

    s = Query(MacroCmdLine)

    cur_fn = GetFileToken(s, 1)
    err_id = Val(GetFileToken(s, 2))
    debug = GetFileToken(s, 3) == "-debug"
    work_id = GetBufferId()

    DbgMsg("In 'jikes' helper macro - output from compiler is displayed", True)
    find_errors(cur_fn, err_id, work_id)
    sort_error_buffer(err_id)
    format_errors(err_id)
    DbgMsg("Leaving 'jikes' helper macro", True)
end

#if 0

string s[] = "c:\d\user\jikes_cmplr\bad.java"
integer bid

proc foo()
    PushPosition()
    bid = CreateBuffer("error buffer")
    PopPosition()
    EditFile("jikes2.txt")
    Set(MacroCmdLine, Format(s; bid))
    jikes()
end

<f3> foo()
#endif
