/*--------------------------------------------------------------
  Mark a block
  Run this macro
  Enter the string to align on
  Enter any needed options

  Examples:

  This:
    fred = xyz
    long_var_name = xxx
    shorter = this
    really_long_one_this_one_is = foo

  Becomes:
    fred                        = xyz
    long_var_name               = xxx
    shorter                     = this
    really_long_one_this_one_is = foo
   Using a simple search for '='

  This:
    lib_abc.sql;36            125       31-jul-2015 07:44:50.64
    lib_frank.sql;15          170   14-jul-2015 09:47:32.57
    lib_def.sql;13             65        3-aug-2015 16:00:18.59
    lib_freddy.sql;1          135         31-jul-2015 07:45:01.19
    lib_thank.sql;2            52      31-jul-2015 07:44:43.53
    xabc_baker.sql;2          545   3-aug-2015 09:08:37.16
    x_paper_spon.sql;1        123   31-jul-2015 07:44:21.05
    x_xyz_foobart.sql;2         6    31-jul-2015 07:44:33.63

  Becomes:
    lib_abc.sql;36            125         31-jul-2015 07:44:50.64
    lib_frank.sql;15          170         14-jul-2015 09:47:32.57
    lib_def.sql;13             65          3-aug-2015 16:00:18.59
    lib_freddy.sql;1          135         31-jul-2015 07:45:01.19
    lib_thank.sql;2            52         31-jul-2015 07:44:43.53
    xabc_baker.sql;2          545          3-aug-2015 09:08:37.16
    x_paper_spon.sql;1        123         31-jul-2015 07:44:21.05
    x_xyz_foobart.sql;2         6         31-jul-2015 07:44:33.63
   Using a regular expression.

   Sep 2015 SEM initial version
 --------------------------------------------------------------*/
integer proc find_min_col(string s, string options)
    integer min_col

    GotoBlockBegin()
    if isBlockMarked() == _LINE_
        BegLine()
    endif
    min_col = 0
    repeat
        if not lFind(s, options)
            return (0)
        endif

        min_col = max(min_col, CurrCol())
    until not lRepeatFind()
    return (min_col)
end

proc do_align(integer min_col, string s, string options)
    GotoBlockBegin()
    if isBlockMarked() == _LINE_
        BegLine()
    endif
    repeat
        if not lFind(s, options)
            return ()
        endif

        PushBlock()
        UnmarkBlock()

        while CurrCol() < min_col
            InsertText(" ", _INSERT_)
        endwhile

        PopBlock()
    until not lRepeatFind()
end

string s[255], options[12] = "l"

proc main()
    integer min_col, marking

    if not isCursorInBlock()
        Warn("Cursor must be in a block")
        return ()
    endif

    if not Ask("String to align:", s) or s == ""
        return ()
    endif

    // put us at the end of the default options
    PushKey(<end>)
    if not Ask("Options:", options)
        return ()
    endif

    // and force the 'l' back in if removed
    if pos("l", lower(options)) == 0
        options = options + "l"
    endif

    PushPosition()
    PushBlock()
    GotoBlockBegin()
    marking = Set(Marking, off)

    min_col = find_min_col(s, options)
    if min_col == 0
        Warn("Cannot find anything to align")
        return ()
    endif

    do_align(min_col, s, options)

    PopPosition()
    PopBlock()
    Set(Marking, marking)
end
