// Blue Wave Mail Reader 2.30 DOS & 386 (DOS) KEYGEN
// by akacastor 2024-04-05


#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <ctype.h>


char *strrev(char *str)
{
      char *p1, *p2;

      if (! str || ! *str)
            return str;
      for (p1 = str, p2 = str + strlen(str) - 1; p2 > p1; ++p1, --p2)
      {
            *p1 ^= *p2;
            *p2 ^= *p1;
            *p1 ^= *p2;
      }
      return str;
}

// ultoa() and ultoa_recursive() from avr-libc
static char *ultoa_recursive(unsigned long val, char *s, unsigned radix)
{
    int c;

    if (val >= radix)
	s = ultoa_recursive (val / radix, s, radix);
    c = val % radix;
    c += (c < 10 ? '0' : 'a' - 10);
    *s++ = c;
    return s;
}

static char *ultoa(unsigned long val, char *s, int radix)
{
    if (radix < 2 || radix > 36)
	s[0] = 0;
    else
	*ultoa_recursive (val, s, radix) = 0;
    return s;
}


// key[] must be at least 9 bytes
// initval=0xB640000
// mulval= 0xF4CEE for DOS 16-bit, 0xFB541 for DOS386
// addval= 0x16 for DOS 16-bit, 0x2C for DOS386
int bw23_keygen(char *reg_name, char *reg_key, uint32_t initval, uint32_t mulval, uint32_t addval)
{
    int i;
    uint32_t ax;    
    uint32_t key_val = 0xB640000;
    char reg_name_local[36];


    if( (!reg_name) || (!reg_key) )
        return -1;  // NULL pointers passed

    reg_name_local[0] = '\0';
    strncpy( reg_name_local, reg_name, 35 );
    reg_name_local[35] = '\0';

    if( strlen(reg_name_local) < 2 )
        return 1;   // error - reg_name is too short (must be at least 2 characters)

    for( i=0; i<strlen(reg_name_local); i++ )
        reg_name_local[i] = toupper(reg_name_local[i]);
    
    for( i=0; i<strlen(reg_name_local); i++ )
    {
        ax = (reg_name_local[i] + (reg_name_local[i] | (i+1))) * mulval + key_val;
                    
        if( ax > key_val || ( ax = key_val + addval + reg_name_local[i], ax > key_val ) )
            key_val = ax;
    }
    
    ultoa( key_val, reg_key, 24 );
    reg_key[7] = '\0';
    
    strrev( reg_key );
    reg_key[7] = tolower(reg_name_local[0]);
    reg_key[8] = '\0';

    for( i=0; i<8; i++ )
    {
        if( reg_key[i] == 'o' || reg_key[i] == 'O' || reg_key[i] == '0' )
            reg_key[i] = 'x';
    }


    return 0;
}


int main(int argc,char **argv)
{
    int i;
    char reg_name[1024] = "";
    char reg_key_dos[16] = "";
    char reg_key_386[16] = "";


    if( argc<2 )
    {
        printf( "usage: %s <Name>\n\n", argv[0] );
        return 1;
    }

    reg_name[0] = '\0';
    for( i=1; i<argc; i++ )
    {   // copy from command-line to reg_name[]
        strncpy( reg_name+strlen(reg_name), argv[i], sizeof(reg_name)-strlen(reg_name) );
        reg_name[sizeof(reg_name)-1] = '\0';

        if( i+1 < argc && strlen(reg_name) < sizeof(reg_name)-2 )
        {   // insert space between names entered on commandline
            reg_name[strlen(reg_name)+1] = '\0';
            reg_name[strlen(reg_name)] = ' ';
        }
    }
    
    if( bw23_keygen( reg_name, reg_key_dos, 0xB640000, 0xF4CEE, 0x16 ) )
    {
        printf( "Unable to create key for Name: '%s'\n", reg_name );
        return 1;
    }

    if( bw23_keygen( reg_name, reg_key_386, 0xB640000, 0xFB541, 0x2C ) )
    {
        printf( "Unable to create key for Name: '%s'\n", reg_name );
        return 1;
    }

    printf( "\n"
            "                                        T H E       @         ############     \n"
            "                                                  @ @           ####     ###   \n"
            "Blue Wave Mail Reader DOS 16-bit 2.30             @@@            ###      #### \n"
            "KEYGEN by akacastor 2024-04-05                 @@ @@@@ @@        ###       ####\n"
            "                                             @@@   @@   @@       ###        ###\n"
            "                                           @@     @@@@    @@     ###       ####\n"
            "                                          @@     @@  @     @@    ###       ### \n"
            "                                         @       @@  @@      @   ###     ####  \n"
            "                                         @      @@    @@     @@@@##########    \n"
            "Name: %-35.35s@      @@    @@  @@@@@@ ###           \n"
            "                                         @      @@    @@@@@@ @   ###           \n"
            "Key:  %8.8s [2.30/DOS]                @     @@  @@@@@@    @   #M#           \n"
            "Key:  %8.8s [2.30/386 (DOS)]          @     @@@@@@  @@    @   #t#           \n"
            "                                          @@  @@@@      @@ @@    #M#           \n"
            "                                           @@@@@        @@@@     ###           \n"
            "                                         @@@ @@@         @@      ###           \n"
            "                                       @@@   @@ @@@@@@@@ @@@    #####          \n"
            "                                             @@           @@  #########        \n"
            "                                            @@             @@                  \n"
            "                                            @               @       C L A S S  \n"
            "                   guess what... 1994, 2024, your shit's still getting cracked.\n"
            "         it's just now more of a philanthropic move instead of an anarchist one\n",
            reg_name, reg_key_dos, reg_key_386 );


    return 0;
}
